function d=dBuild(infile, useDays, nMax);
%	dbuild function dbuild(infile, useDays, nMax)
%	returns data structure for MCMC analysis
%	infile 		row is: day price volume
%	useDays		missing or =0 -> use all days; otherwise a vector of days to use
%	nMax			max number of observations
%
disp('starting...')
x=load(infile);
if nargin>=2 & useDays(1)>0
   j = ismember(x(:,1),useDays);
   x = x(j,:);
end
%disp('Days used:');
%disp(unique(x(:,1)));
[n,m] = size(x);
if nargin==3 & nMax<n;
   x=x(1:nMax,:);
   n = nMax;
end
k = find([0;diff(x(:,1))]);
nDay = length(k)+1;
disp(['Data span ' int2str(nDay) ' days.']);
dStart = [1;k];
dEnd = [k-1;n];
disp(num2str([dStart dEnd]));
for i=1:nDay
   d(i).P = transpose( x(dStart(i):dEnd(i),2) );	%	prices
   %	verify that all prices are integers
   if any(rem(d(i).P,1)~=0)
      disp('Non-integer price.');
      d=0;
      return;
   end
   d(i).p = log(d(i).P);
   d(i).v = transpose( x(dStart(i):dEnd(i),3) );	%	trades
   d(i).x = sqrt(d(i).v);
end
